public class PrinterProxy implements Printable {
    private String name;            // O
    private Printable real;         // u{lv
    private String className;       // u{lṽNX

    // RXgN^iOƃNXwj
    public PrinterProxy(String name, String className) {
        this.name = name;
        this.real = null;
        this.className = className;
    }

    // O̐ݒ
    @Override
    public synchronized void setPrinterName(String name) {
        if (real != null) {
            // u{lvɂݒ肷
            real.setPrinterName(name);
        }
        this.name = name;
    }

    // O̎擾
    @Override
    public String getPrinterName() {
        return name;
    }

    // \
    @Override
    public void print(String string) {
        realize();
        real.print(string);
    }

    // u{lv𐶐
    private synchronized void realize() {
        if (real == null) {
            try {
                real = (Printable)Class.forName(className).getDeclaredConstructor().newInstance();
                real.setPrinterName(name);
            } catch (ClassNotFoundException e) {
                System.out.println("NX " + className + " ܂B");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
