import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SafeFrame extends Frame implements ActionListener, Context {
    private TextField textClock = new TextField(60);        // ݎ\
    private TextArea textScreen = new TextArea(10, 60);     // xZ^[o
    private Button buttonUse = new Button("Ɏgp");      // Ɏgp{^
    private Button buttonAlarm = new Button("x");    // x{^
    private Button buttonPhone = new Button("ʏʘb");    // ʏʘb{^
    private Button buttonExit = new Button("I");         // I{^

    private State state = DayState.getInstance();           // ݂̏

    // RXgN^
    public SafeFrame(String title) {
        super(title);
        setBackground(Color.lightGray);
        setLayout(new BorderLayout());
        // textClockzu
        add(textClock, BorderLayout.NORTH);
        textClock.setEditable(false);
        // textScreenzu
        add(textScreen, BorderLayout.CENTER);
        textScreen.setEditable(false);
        // plɃ{^i[
        Panel panel = new Panel();
        panel.add(buttonUse);
        panel.add(buttonAlarm);
        panel.add(buttonPhone);
        panel.add(buttonExit);
        // ̃plzu
        add(panel, BorderLayout.SOUTH);
        // \
        pack();
        setVisible(true);
        // Xi[̐ݒ
        buttonUse.addActionListener(this);
        buttonAlarm.addActionListener(this);
        buttonPhone.addActionListener(this);
        buttonExit.addActionListener(this);
    }

    // {^ꂽ炱ɗ
    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(e.toString());
        if (e.getSource() == buttonUse) {           // Ɏgp{^
            state.doUse(this);
        } else if (e.getSource() == buttonAlarm) {  // x{^
            state.doAlarm(this);
        } else if (e.getSource() == buttonPhone) {  // ʏʘb{^
            state.doPhone(this);
        } else if (e.getSource() == buttonExit) {   // I{^
            System.exit(0);
        } else {
            System.out.println("?");
        }
    }

    // ̐ݒ
    @Override
    public void setClock(int hour) {
        String clockstring = String.format("ݎ%02d:00", hour);
        System.out.println(clockstring);
        textClock.setText(clockstring);
        state.doClock(this, hour);
    }

    // ԕω
    @Override
    public void changeState(State state) {
        System.out.println(this.state + "" + state + "֏Ԃω܂B");
        this.state = state;
    }

    // xZ^[xĂяo
    @Override
    public void callSecurityCenter(String msg) {
        textScreen.append("call! " + msg + "\n");
    }

    // xZ^[L^
    @Override
    public void recordLog(String msg) {
        textScreen.append("record ... " + msg + "\n");
    }
}
